# menu_inc.py
'''
メニュー設置を簡素化するためのラッパー関数

まず最初に
  ルートを引数としてmkmenubar()コマンドをコールする。
  戻り値：作成されたメニューバー
次に
  必要なだけaddcommands()をコールして呼び出す。
  戻り値：作成されたカスケードメニュー
  このaddcommands()はinsertでカスケードメニューを
  登録するインデックスを指定すると挿入処理を行う
  主な引数は
    親になるメニュー
    親メニューに表示されるラベル
    カスケードメニューに登録するラベルと処理関数

'''

from tkinter import *

#ルートにメニューを設置し、
#最初のメニューバーをルートにリンクさせる
#root: Tk()で作成　必須
def mkmenubar(root):
  menubar = Menu(root)
  root.configure(menu=menubar)
  return menubar

#親（メニューバーなど）にカスケードメニューを追加・挿入し、
#そのメニューにコマンドボタンを設置する
#parent: menubarやメニュー
#casclabel:parentに設置するメニューラベル
#underline:メニューラベルへのアクセスキー番号
#commands:コマンドラベルとコールバックのリスト
#  [['somelabel',callback],..] ただし、['',any]はセパレータ
#insert: カスケードメニューを挿入する位置(Noneの場合は単なる追加)
def addcommands(parent,casclabel=None,underline=None,
                commands=None,insert=None):
  cmenu = Menu(parent,tearoff=0)
  if insert == None:
    parent.add_cascade(label=casclabel,underline=underline,
                       menu=cmenu)
  else:
    parent.insert_cascade(insert,label=casclabel,
                          underline=underline,menu=cmenu)
  if commands:
    for i in commands:
      if not i[0]:
        cmenu.add_separator()
      else:
        cmenu.add_command(label=i[0],command=i[1])
  return cmenu

#------------------------------------------------
if __name__=='__main__':
  #--test用のcallback---
  def func001():
    pass
  def func002():
    pass
  #---------------------
  root = Tk()
  #rootを親にメニューバーを作る
  #戻り値はメニューバー
  menubar = mkmenubar(root)
  #メニューバーにカスケードメニューを登録する
  #メニューバーに表示されるラベル
  casclabel = 'F)ファイル'
  #ショートカットが必要なら該当する文字へのインデックスを与える
  underline = 0  #Noneと0は区別する Noneの場合は指定不要
  #カスケードメニューに登録するラベルと処理関数。必要なだけ
  commands = [['開く',func001],['',''],['終了',func002]]
  #メニューバーにカスケードメニュー追加
  #戻り値はカスケードメニュー
  filemenu = addcommands(menubar,casclabel,underline=underline,
                         commands=commands)
  #カスケードメニューに更にカスケードメニューを登録する
  casclabel = 'サブメニュー'
  commands = [['サブ１',func001],['サブ２',func002]]
  #insert:カスケードメニューを挿入する位置
  submenu = addcommands(filemenu,casclabel,commands=commands,
                        insert=1)
  root.mainloop()
