#panedwin.py
#
#結果表示ウィンドウのPanedWindow版

'''
・panedframe.pyで変換済みテキストを表示していたが左右の表示がずれるという
  問題があったので、PanedWindowを使って左右の表示を１つの行にまとめる
  ことにした。

・panedframe.pyで実装していた基本機能をpanedwin.pyで置き換える。
'''

from tkinter import *
import re,sys
from tkinter import messagebox as msgbox
import time
import threading
#不要かも
from . import load_helper as lhp
from . import wait_tips_inc as tips
from . import scrollbar_inc as sci

class panedwin():
  def __init__(self,parent):
    #parentのサイズは呼び出し元で設定すべし
    #サイズが未指定の場合期待どおりには動かない
    self.master = parent
    self.mainwin = None  #親OBJにアクセスする手段　親OBJからセットされる
    self.maintk = None  #親ウィンドウのtk
    self.mastersize = []  
    self.after_id = ''
    self.existwin = True    #このウィンドウが破棄されたときにFalseとなる
    #text1list,text2listが更新されるとTrue、書き出しされるとFalse
    self.textlistupdated = False
    #子ウィンドウとして起動されたときに外部からTrueにセットされる
    self.iamchild = False
    #このウィンドウで全体を終了させる場合 True 親側.after()でチェックしている
    self.closing = False
    #保存データを復元中を知らせるフラグself.append()の動作に影響する
    self.restoreflg = False
    #フォントサイズ (tkinterではfloat値のサイズ指定はできない）
    self.fontsize = '10'
    self.fontmax = 14
    self.fontmin = 6
    #左右表示入れ替えフラグ 基本：True、入れ替え時：False
    self.lrflg = True
    #ウィンドウタイトル保存
    self.titlename = parent.title()
    #一時的な行高を増やす割合 デフォルト1.1倍(10%増し)
    self.gain_height_ratio = 1.1
    #すべての行の左右幅を変更中のフラグ
    self.allsashmoving = False
    #表示職
    self.kekafg = None  #文字色
    self.kekabg = None  #背景色
    
    #各行dic: {'fr':frame, 'num':int_num, 'numlbl':numlabel,
    # 'linepw':linepanedwwindow, 'ltxw':lefrtxw, 'rtxw':righttxw}
    #self.linelist: [dic,..]
    self.linelist = []

    self.body(self.master)
    self.basetw_ro()
  
  def body(self,master):
    #ベースのTextウィジェット
    self.basetw = Text(master)
    self.basetw.pack(expand=1,fill=BOTH)
    sci.scrollbarset(master,self.basetw,orient='V')

    #masterウィンドウに連動したbasetwの拡大縮小イベントにバインド
    self.basetw.bind('<Configure>',self.onbasetwresize)
    #マウスホイール
    self.bindmousewheel()
    #Ctrl+C
    self.bind_ctrl_c()
    #ウィンドウコントロールボタン
    self.setprotocol()
    
  #末尾に行追加(self.insert()と兼用)
  #データをロード中は高さ調整の動作を止めるべきか？
  def append(self,lt,rt,idx=None):
    #書き込み可能に
    self.basetw_nor()
    #basetwのサイズ取得
    self.basetw.update_idletasks()
    w,h = self.getwsize(self.basetw)
    #frのwidthはbasetwと同じ。heightは仮値
    fr = Frame(self.basetw,width=w,height=20)
    fr.pack_propagate(0)
    #行番号
    #StringVar()でtextvariableを設定しても行番号が表示されない
    #numvar = StringVar()
    if not idx:
      #numvar.set(str(len(self.linelist)+1))
      num = len(self.linelist)+1
    else:
      #numvar.set(str(idx+1))
      num = idx + 1
    #なぜかtextvariableの値が表示されない
    #numlbl = Label(fr, textvariable=numvar, width=5)
    numlbl = Label(fr, text=str(num), width=5)
    numlbl.pack(side=LEFT)

    #panedwindow
    #opaqueresize=False sashの移動はリリース後
    linepw = PanedWindow(fr,orient=HORIZONTAL,opaqueresize=False)
    linepw.pack(side=LEFT,expand=1,fill=BOTH)

    #basetwにfrを追加
    if not idx:
      self.basetw.window_create(END,window=fr)
      #各行に改行を挿入
      self.basetw.insert(END,'\n')
    else:
      #行挿入前に改行挿入
      self.basetw.insert(str(idx+1)+'.0','\n')
      self.basetw.window_create(str(idx+1)+'.0',window=fr)
    
    #左TextをPWのchildで追加
    ltxw = Text(linepw,fg=self.kekafg,bg=self.kekabg)
    #左paneのwidthを指定 lableとsash(2)+αを控除して/2
    numlbl.update_idletasks()
    lblw,dmy = self.getwsize(numlbl)
    linepw.add(ltxw,width=(w-lblw-6)/2)
    #右Text追加
    rtxw = Text(linepw,fg=self.kekafg,bg=self.kekabg)
    linepw.add(rtxw)
    ltxw.insert(END,lt)
    rtxw.insert(END,rt)
    #window表示の更新
    ltxw.update_idletasks()
    rtxw.update_idletasks()
    #----------------------------
    #### restoreflg=ON 行高調整や追加行への移動などを抑制
    #----------------------------
    if not self.restoreflg:
      #行の高さ調整
      fr.configure(height=self.getheight(ltxw,rtxw))
      #追加された行が見えるように
      if not idx:
        self.basetw.see(END)
      else:
        self.basetw.see(str(idx+1)+'.0')
    #Textウィジェットは編集不可に
    ltxw['state'] = DISABLED
    rtxw['state'] = DISABLED
    #行情報を追加
    linedic = {}
    linedic['fr'] = fr
    #linedic['numvar'] = numvar
    linedic['num'] = num
    linedic['numlbl'] = numlbl
    linedic['linepw'] = linepw
    linedic['ltxw'] = ltxw
    linedic['rtxw'] = rtxw
    if not idx:
      self.linelist.append(linedic)
    else:
      self.linelist.insert(idx,linedic)
    #データ更新
    self.textlistupdated = True

    #sash移動によるltxwのサイズ変更イベントのバインド
    ltxw.bind('<Configure>',self.onltxwresize)

    #テキストボックスのダブルクリックイベント
    #行番号をparentに返す
    #parent側に受け取り用の変数や関数があることをチェック
    ltxw.bind('<Double-Button-1>',self.getlinenum,'+')
    rtxw.bind('<Double-Button-1>',self.getlinenum,'+')
    #中クリックでその行ブロックの高さを増やす
    #このバインドは不要かも？
##    ltxw.bind('<ButtonRelease-2>',self.gain_height,'+')
##    rtxw.bind('<ButtonRelease-2>',self.gain_height,'+')
    #書き込み不可に
    self.basetw_ro()

  #一時的に該当行の高さを増やす
  #このメソッドは不要かも
##  def gain_height(self,ev):
##    #該当の行番号を取得する
##    ok = False
##    for idx,item in enumerate(self.linelist):
##      if item['linepw'] == ev.widget.master:
##        ok = True
##        break
##    if ok:
##      #該当行のフレーム高さを一定割合増やす
##      fr = item['fr']
##      #現在の高さ * self.gain_height_ratio
##      fr['height'] = int(fr.winfo_reqheight() * self.gain_height_ratio)

  #ダブルクリックされた行番号をメイン側のエントリーに入れる
  def getlinenum(self,ev):
    if self.checkmaster():
      for item in self.linelist:
        if item['linepw'] == ev.widget.master:
          #self.mainwin.setnumentry(int(item['numvar'].get()))
          self.mainwin.setnumentry(item['num'])
          return

  #master側に行番号を受ける体制があることを確認
  def checkmaster(self):
    if not self.mainwin:
      return False
    if hasattr(self.mainwin,'setnumentry'):
      return True
    else:
      return False


  #左右のTextのリサイズはsashの移動のみで可能
  def onltxwresize(self,ev):

    if not self.allsashmoving:
      self.allsashmoving = True
      #Textウィジェットの親(childpw)を調べる
      parentpw = ev.widget.master
      #sashの位置を得る
      x,y = parentpw.sash_coord(0)
      #すべての行のサッシュを移動
      for dic in self.linelist:
        if dic['linepw'] != parentpw:
          #Horizontalのpanedwindowの場合y値は無視される
          dic['linepw'].sash_place(0,x,y)
      #画面を更新する
      self.master.update_idletasks()
      self.allsashmoving = False
    #ltxw,rtxw,frを得て行の高さを調整する
    for dic in self.linelist:
      if dic['ltxw'] == ev.widget:
        #sash移動後のTextウィジェットの高さを調整する
        dic['fr'].configure(height=self.getheight(dic['ltxw'],dic['rtxw']))
        break
    
  #指定された位置に行挿入（追加）
  def insert(self,idx,lt,rt):
    self.append(lt,rt,idx)
    #idx+1以降の行番号を繰り下げる
    self.renumber(idx+1)

  #-------- テキストリストの行番号を振り直す-----
  # index番号以降のテキストリスト
  # indexを基準に番号を振り直す
  def renumber(self,index):
    num = index + 1
    for dic in self.linelist[index:]:
      #dic['numvar'].set(str(num))
      dic['num'] = num
      dic['numlbl'].configure(text=str(num))
      num += 1

  ##=== 指定された行番号が存在するかどうか =====
  #戻り値：[True or False,テキストリストのindex]
  def isexistnum(self,num):
    exist = False
    for dic in self.linelist:
      if dic['num']==num:
        exist = True
        break
    if exist:
      return [True,self.linelist.index(dic)]
    else:
      return [False,'']

  ##======== 指定された行を削除する ====
  def delete(self,index):
    self.basetw_nor()
    #linelistから削除
    pop = self.linelist.pop(index)
    #basetw上の行（フレーム）を削除
    pop['fr'].destroy() #.forget()や.remove()の方がよいか？
    #Text-widgetに残った改行を削除
    self.basetw.delete(str(index+2)+'.0 -1c')
    #削除後にテキストリスト上の行番号を調整
    self.renumber(index)
    #
    self.textlistupdated = True
    self.basetw_ro()

  ##------ インデックスで指定された左右のテキストを返す-----
  def getlrtext(self,idx):
    dic = self.linelist[idx]
    lt = dic['ltxw'].get('1.0',END).strip()
    rt = dic['rtxw'].get('1.0',END).strip()
    return [lt,rt]

  ##==========  インデックス番号のテキストデータを置きかえる =====
  def replace(self,idx,lt,rt):
    self.basetw_nor()  #編集可能
    dic = self.linelist[idx]
    dic['ltxw']['state'] = NORMAL
    dic['ltxw'].delete('1.0',END)
    dic['ltxw'].insert('1.0',lt)
    dic['ltxw']['state'] = DISABLED
    dic['rtxw']['state'] = NORMAL
    dic['rtxw'].delete('1.0',END)
    dic['rtxw'].insert('1.0',rt)
    dic['rtxw']['state'] = DISABLED
    #ベースのテキストボックスを更新
    self.basetw.update_idletasks()
    #行の高さ調整
    dic['fr'].configure(height=self.getheight(dic['ltxw'],dic['rtxw']))
    #対象の行が見えるように
    self.basetw.see(str(idx+1)+'.0')
    #
    self.textlistupdated = True
    self.basetw_ro()   #編集不可

  #フォントサイズ変更（メイン側からコールされる）
  def chgfontsize(self,sizestr=None):
    if sizestr and not sizestr == self.fontsize:
      if int(sizestr)< self.fontmin or int(sizestr)>self.fontmax:
        return
      for idx,dic in enumerate(self.linelist):
        dic['ltxw']['font'] = ('',sizestr)
        dic['rtxw']['font'] = ('',sizestr)
        dic['ltxw'].update_idletasks()
        dic['rtxw'].update_idletasks()
        dic['fr'].configure(height=self.getheight(dic['ltxw'],dic['rtxw']))
      self.fontsize = sizestr

  ##---- テキストリストの中身を受け取ってテキストリストに復元する
  ##　復元するときメインから呼ばれる
  # textlist : [[linenum, text1str, text2str ],,]
  def restoretextlist(self,textlist):
    #１件ずつtext_widgetに追加 frame_labelw_textw
    #１件ずつtext1list,text2listに追加
    #反転フラグなどをクリア
    self.lrflg = True
    self.master.title(self.titlename)
    #basetwとlinelistをクリア
    self.basetw_nor()  #編集可能に
    #既存の表示をクリアする
    if self.linelist:
      self.basetw.delete('1.0',END)
    #テキストリストもクリア
    self.linelist = []

    #作業メッセージチップス
    tiptxt = '保存されたデータを読み込んでいます。\nしばらくお待ちください。'
    wtip = tips.wait_tips(self.maintk,message=tiptxt,txw=25,txh=5)

    #一旦、ロードヘルパーなしで試してみる
    #restoreflg:ONにして行高や行表示をOFFにして全行を挿入
    #その後、まとめて全行の高さを調整する
    self.restoreflg = True
    #全行を1行ずつ追加
    for num,lt,rt in textlist:
      self.append(lt,rt)
    #全行の高さを調整
    for dic in self.linelist:
      dic['fr'].configure(height=self.getheight(dic['ltxw'],dic['rtxw']))
    
    #作業メッセージをクリア
    wtip.cancel()
    #h復元後に更新フラグをクリア
    self.clearupdated()
    #restoreflg
    self.restoreflg = False
    self.basetw_ro()   #編集禁止

  ##----------------------------------------------
  # 左右のテキスト表示を入れ替える
  # 基本は左：原文、右：訳文
  def leftright(self):
    #ヘルパーを使わずに左右入れ替えしてみる
    #全行のテキストを1行ずつ左右入れ替え
    for dic in self.linelist:
      dic['ltxw']['state'] = dic['rtxw']['state'] = NORMAL
      lt = dic['ltxw'].get('1.0',END).strip()
      rt = dic['rtxw'].get('1.0',END).strip()
      dic['ltxw'].delete('1.0',END)
      dic['rtxw'].delete('1.0',END)
      dic['ltxw'].insert('1.0',rt)
      dic['rtxw'].insert('1.0',lt)
      dic['ltxw']['state'] = dic['rtxw']['state'] = DISABLED
      #同時に高さも調整
      dic['fr'].configure(height=self.getheight(dic['ltxw'],dic['rtxw']))
    #後始末(フラグ、タイトル)
    if self.lrflg:
      self.lrflg = False
      self.master.title(self.titlename+'（反転中）')
    else:
      self.lrflg = True
      self.master.title(self.titlename)
    
  ##-----テキストリストの中身（行番号と左右のテキスト）を
  ##リストにして返す
  def gettextlistitm(self):
    textlist = []  #[ [linenum,text1str,text2str],..]
    for idx,dic in enumerate(self.linelist):
      il = [ #dic['numvar'].get(),
             dic['num'],
             dic['ltxw'].get('1.0',END).strip(),
             dic['rtxw'].get('1.0',END).strip() ]
      textlist.append(il)
    if not self.lrflg:    #左右反転してたら
      for i in textlist:
        i[1], i[2] = i[2], i[1]
    return textlist


  ## ------ テキストリストの更新状況と件数を返す ------
  def updatecount(self):
    return [self.textlistupdated,len(self.linelist)]
  
  ##----- 更新フラグをクリアする ----
  def clearupdated(self):
    self.textlistupdated = False

  ## ------ テキストリストの変更の有無を返す -----
  def isupdated(self):
    if self.textlistupdated:
      return True
    else:
      return False

  ##-------------------------
  ## 指定された行番号を表示する
  ## num:string
  def goto(self,linenumstr):
    self.basetw.see(linenumstr+'.0')

  #左右のTextウィジェットを与えて必要な高さを返す
  def getheight(self,ltxw,rtxw):
    ltxw_hi = ltxw.count("1.0", "end", "ypixels")[0]
    rtxw_hi = rtxw.count("1.0", "end", "ypixels")[0]
    ltxw_li = ltxw.count("1.0", "end", "displaylines")[0]
    rtxw_li = rtxw.count("1.0", "end", "displaylines")[0]
    if ltxw_hi >= rtxw_hi:
      #(表示行数＋１)*2.5  調整
      heig = ltxw_hi+(ltxw_li+1)*2.5
    else:
      heig = rtxw_hi+(rtxw_li+1)*2.5
    return heig
  
  #wi:widgetのサイズを値で返す（位置情報は無視）
  def getwsize(self,wi):
    wi.update_idletasks()
    geostr = wi.winfo_geometry()
    res = re.search('([0-9]*?)x([0-9]*?)[+-].*',geostr)
    if res:
      return [int(res.group(1)),int(res.group(2))]
    else:
      return False

  #ベースTextウィジェットの拡大縮小イベントのコールバック
  def onbasetwresize(self,ev):
    if not self.linelist:
      return
    #childTextの幅を均等にする
    #１行目のpwのサイズを取得してsashをpwのセンターに移動する
    #残りの行の幅や高さの調整はonltxwresize()で処理される
    basew,baseh = self.getwsize(self.basetw)
    #すべての行のfrをbasewにする
    for line in self.linelist:
      line['fr'].configure(width=basew)
    #１行目のsashを中央に移動する
    line = self.linelist[0]
    lblw,lblh = self.getwsize(line['numlbl'])
    pww,pwh = self.getwsize(line['linepw'])
    newsashw = int(pww/2)
    nowsashw,nowsashh = line['linepw'].sash_coord(0)
    line['linepw'].sash_place(0,newsashw,nowsashh)

  #ウィンドウクローズ時の動作
  def on_closing(self):
    if self.iamchild:
      #子ウィンドウで起動したときには直接終了しないのが筋
      msg = '作業を終了しますか？'
      if msgbox.askokcancel('closing',msg,parent=self.master):
        #self.master.destroy() translate_main側で閉じる
        #self.existwin = False
        self.closing = True
    else:
        self.master.destroy()

  #ウィンドウの閉じるボタンの制御
  def setprotocol(self):
    self.master.protocol('WM_DELETE_WINDOW', self.on_closing)
  
  #mouse_wheel動作にバインド
  ## Linux用 (Mac,Windowsは今のところ対象外)
  ## Windowsは'<MouseWheel>'イベントらしい
  def bindmousewheel(self):
    self.master.bind('<Button-4>',self.mousewheel)
    self.master.bind('<Button-5>',self.mousewheel)

  #Linux: ev.deltaは常に0
  #Linux: ev.num は Button番号 4 or 5
  def mousewheel(self,ev):
    if ev.num == 5:
      self.basetw.yview(SCROLL,1,UNITS)
    elif ev.num == 4:
      self.basetw.yview(SCROLL,-1,UNITS)

  #ctrl_cで選択範囲をクリップボードに
  def ctrl_c(self,ev):
    try:
      w = self.master.selection_own_get()
    except Exception as err:
      return
    cptx = w.selection_get()
    w.clipboard_clear()
    w.clipboard_append(cptx)
  
  #Disabled_Textのctrl_cのバインド
  def bind_ctrl_c(self):
    self.master.bind_all('<Control-KeyPress-c>',self.ctrl_c,'+')
  
  #左右のTextWを編集不可に設定（表示領域を編集されては困るので）
  def basetw_ro(self):
    self.basetw['state'] = DISABLED

  def basetw_nor(self):
    self.basetw['state'] = NORMAL

  #self.basetwの背景色のみself.kekabgで更新する
  def basetwcolor(self):
    self.basetw['bg'] = self.kekabg

  #self.kakefg, self.kekabgの値に従って表示色を変更する
  def changecolors(self):
    #basetw,各pwの子のTextを変更する
    for dic in self.linelist:
      dic['ltxw']['fg'] = self.kekafg
      dic['ltxw']['bg'] = self.kekabg
      dic['rtxw']['fg'] = self.kekafg
      dic['rtxw']['bg'] = self.kekabg
  

#---------------------------------------------------------
if __name__=='__main__':
  root = Tk()
  root.geometry('800x500')
  obj = panedwin(root)
