# wait_tips_inc.py
'''
時間がかかる処理中にメッセージを表示するウィンドウ。
タイトルバーとボタン類がないメッセージだけのウィンドウ。
ウィンドウの設置と破棄はプログラム側で行う。
（モードレスダイアログ）
'''

from tkinter import *
from tkinter import simpledialog as smpl


#タイトルバー、ボタンはOFF
#他のウィンドウを止めないように.grab_set(),wait_window()はコメントアウト
#message:ひとまずテキストで
#font:メッセージ用のフォント ('fontname',size,style?)
#fgcolor,bgcolor:フォント、背景色
#txw,txh:Text-Widgetの幅、行数
#tagjustify,tagspacing1,tagspacing2:tag設定
#taglmargin1,taglmargin2,tagrmargin:tag設定
class wait_tips(smpl.Dialog):
  def __init__(self,parent,title=None,message=None,font=('',16),
               fgcolor='black',bgcolor='#F9F06F',txw=30,txh=10,
               tagjustify=CENTER,tagspacing1=20,tagspacing2=5,
               taglmargin1=20,taglmargin2=20,tagrmargin=20):
    self.font = font
    self.fgcolor = fgcolor
    self.bgcolor = bgcolor
    self.message = message
    self.txw = txw
    self.txh = txh
    self.tagjustify = tagjustify
    self.tagspacing1,self.tagspacing2 = tagspacing1,tagspacing2
    self.taglmargin1,self.taglmargin2 = taglmargin1,taglmargin2
    self.tagrmargin = tagrmargin
    #---ここから simpledialog.Dialogの__init__()をコピーして一部修正
    Toplevel.__init__(self, parent)
    self.withdraw()
    if parent.winfo_viewable():
      self.transient(parent)
    if title:  #タイトルバーはないので無意味
      self.title(title)
    self.parent = parent
    self.result = None
    body = Frame(self)
    self.initial_focus = self.body(body)
    body.pack()  #padx=5, pady=5) #余白は不要
    self.buttonbox()
    if not self.initial_focus:
      self.initial_focus = self
    self.protocol("WM_DELETE_WINDOW", self.cancel)
    if self.parent is not None:
      self.geometry("+%d+%d" % (parent.winfo_rootx()+50,
                                parent.winfo_rooty()+50))
    #タイトルバーOFF
    self.overrideredirect(True)
      
    self.deiconify()
    self.initial_focus.focus_set()
    # wait for window to appear on screen before calling grab_set
    self.wait_visibility()
#    self.grab_set()
#    self.wait_window(self)
    #--------------ここまで--　simpledialog.Dialog.__init__()----

  def buttonbox(self):
    pass

  #フォントは指定フォント
  #テキストの配置はtagで
  def body(self,master):
    fr = Frame(self,bg=self.bgcolor)  
    txtw = Text(fr,bg=self.bgcolor,fg=self.fgcolor,font=self.font,
                width=self.txw,height=self.txh,bd=0)
    txtw.tag_config('tagname',justify=self.tagjustify,spacing1=self.tagspacing1,
                    spacing2=self.tagspacing2,lmargin1=self.taglmargin1,
                    lmargin2=self.taglmargin2,rmargin=self.tagrmargin)
    txtw.pack()
    fr.pack()
    txtw.insert(END,self.message)
    txtw.tag_add('tagname','1.0',END)
    txtw['state'] = DISABLED

#-----------------------------------------------
if __name__=='__main__':
  def tips_on():
    global tips
    if 'tips' in globals() and tips:
      return
    else:
      tips = wait_tips(root,message='メッセージ',txw=20,txh=5)
    
  def tips_off():
    global tips
    if 'tips' in globals() and tips:
      tips.cancel()
      tips = None

  root = Tk()
  lbl = Label(root,text='チップスウィンドウのテスト')
  lbl.pack(padx=20,pady=20)
  btn = Button(root,text='tips_on',command=tips_on)
  btn.pack(side=LEFT,padx=10,pady=20)
  btn = Button(root,text='tips_off',command=tips_off)
  btn.pack(padx=10,pady=20)

  
  
