#spinbox_inc.py
'''
tkinter.spinboxのラッパー

最高値、最低値、現在値、増減値を与えてスピンボックスを開始
選択結果：self.value （文字列）
OKで現在の値セット
cancelでNoneをセット

'''

from tkinter import *

#title:タイトル文字列
# 値はinteger値（not float）
#spmax:最大値, spmin:最小値, spinc:増減分, spcur:現在値
class spinbox():
  def __init__(self,spmax=None,spmin=None,spcur=None,spinc=1,
               title=None,label=None):
    self.master = Tk()
    self.spmax = spmax
    self.spmin = spmin
    self.spcur = spcur
    self.spinc = spinc
    self.label = label
    self.value = None
    if title:
      self.master.title(title)
    else:
      self.master.title('Spinbox')
    self.body(self.master)
    self.master.lift()

  def body(self,master):
    spinfr = Frame(master)
    btnfr = Frame(master)

    btnok = Button(btnfr,text='OK',command=self.ok_click)
    btncancel = Button(btnfr,text='cancel',command=self.cancel_click)

    if self.label:
      label = Label(spinfr,text=self.label)
      label.pack()
    self.spin = Spinbox(spinfr,state='readonly',justify=CENTER,width=10,
                        from_=self.spmin,to=self.spmax,increment=self.spinc)
    #spcurの値まで進める
    if self.spcur and self.spmin and self.spmax:
      if self.spcur > self.spmax:
        self.spcur = self.spmax
      while int(self.spin.get()) < self.spcur:
        self.spin.invoke('buttonup')

    self.spin.pack()
    btnok.pack(side=LEFT)
    btncancel.pack(side=LEFT)

    spinfr.pack()
    btnfr.pack(pady=10)

  def ok_click(self):
    self.value = self.spin.get()
    self.on_closing()

  def cancel_click(self):
    self.on_closing()
    
  #終了処理制御
  def setprotocol(self):
    self.master.protocol('WM_DELETE_WINDOW', self.on_closing)

  def on_closing(self):
    self.master.destroy()

#----------------------------------------------
if __name__=='__main__':
  root = Tk()
  spin = spinbox(label='表示フォントサイズの指定',
                 spmax=14,spmin=6,spcur=10)
  root.mainloop()
  print(type(spin.value),spin.value)
  
